
11//scilab 5.5.2 , OS: Ubuntu 14.04
//Design a differentiator using a Hamming window of length N=21. Plot the time and frequency domain response
//Inputs: Window length and Type of window
//The frequency response of a linear-phase ideal differentiator is given by 
//Hd(e jw) =   j ω, 0< ω < π 
//                 -jw,   - π < ω < 0
//The ideal impulse response of a digital differentiator shifted by α with linear phase is given by 
//hd(n– α) =   cos π (n – α) / ( n -  α), n ≠ α
//                   0,   n =  α

//Scilab Program: 
clc;clear;close;
N = 41;// input("enter the window length");  //55
freq_points=1024; 
windowfn =window('hm',N);//Hamming wuindow (Try with different windows)
m = 0:N-1;
aph = (N-1)/2;
for n=0:N-1
    if n==aph
        hd(n+1)=0;
       
 else
     hd(n+1)= cos(%pi*(n-aph))./(n-aph);   
     
end
end
n=0:N-1;
 hn = hd.*windowfn';
 
omega=-%pi:2*%pi/(freq_points-1):%pi; 

z=%z;
den1=real(z^(N-1));
num=0;
for n=0:N-1
    num=num+(hn(n+1).*z^(N-n-1));
end
num1=real(num);
Hz=num1./den1;
w=exp(%i*omega);
rep=freq(Hz("num"),Hz("den"),w);
magH=abs(rep);
figure;subplot(211),plot2d3(m,hn),xtitle('Impulse response','n','h[n]'),subplot(212),plot2d(omega,magH);
xtitle('Magnitude response','w (rad)','Magnitude');
//Expected result
//Magnitude response graph



